#include "DCI_Close.h"

#include <algorithm>
#include <iostream>

#include <time.h>
using namespace std;

#pragma warning(disable : 4786)

DCI_Close::DCI_Close()
{
	data=0;
	minutil=0;
	ntrans=0;
	verbose=false;
	passRest=false;
	bitmap.resize(0);
	remap.resize(0);
	mtwu.resize(0);
	itemcount.resize(0);
	hui.resize(0);
	maxlength = 0;
	resultnum = 0;
	total = 0;
	htwui = 0;
}

DCI_Close::~DCI_Close()
{
	if(data) 
	{
		delete data;
		data=0;
	}
}

class KeyElement                //ģݿ
{
public:
	int key;
	int support;
	//int itemnum;
	vector<int> item;
	vector<int> count;
	vector<int>::iterator it_item;
	vector<int>::iterator it_count;
	//int *num;                  //ָ洢ִĶά

	KeyElement(int pkey, int psupport=0) : key(pkey), support(psupport) {}
	bool operator<(const KeyElement &e) const { return key < e.key; }
};

class ItemSupport              
{
public:
	int item;
	int support;
	vector<int> tid;
	vector<int> count;
	
	ItemSupport(int pitem,int psupport=0) : item(pitem), support(psupport) {}
	bool operator<(const ItemSupport &e) const { return item < e.item; }
	bool operator==(const ItemSupport &e) const { return (item == e.item)? true : false; }
};


void printItemBitmap(ItemBitmap &ib)
{
	int i;
	for(i=0; i<ib.nBits(); i++) cout<< ib.getBit(i);
	cout<<" (util:"<<ib.getSupport()<<")"<<endl;
}


int DCI_Close::initBitmap()
{

	if(verbose) cout<<"init bitmap..."<<endl;
	set<KeyElement> key_set;
	set<KeyElement>::iterator it_ks;
	key_set.clear();

	//if(verbose) cout<<"	genrate k-1 frequent sets"<<endl;
	ItemProfit.resize(0);	                             //ļжȡȨֵ
	int ptran=0;
	while(Transaction *t = dataPro->getNext())
	{
		int *ipro = t->t, sl = t->length;
		for(int i=0; i<sl;)
		{
			if(ipro[i]==ptran)
			{
				i++;
				ItemProfit.push_back(ipro[i]);
				break;
			}
			else
			{
				ItemProfit.push_back(0);
				ptran++;
				//break;
			}
		}
		ptran++;
	}

	int tran=0;
	//int inum = 0;
	//for(int i=0; i<L; i++)
	//{
	//	for(int j=0; j<C; j++)
	//		ItemNum[i][j] = 0;
	//}
	//int testCount[][5] = {{2,1,1},{2,1,1},{1,1,10},{1,15},{1,1,1},{2,1,10},{2,8,1},{1,1,1,2},{1,1,10},{1,1,5},{1}};


	int totalTU = 0;
	set<ItemSupport> is_set;
	set<ItemSupport>::iterator it_is;
	is_set.clear();

	while(Transaction *t = data->getNext())
	{
		int *iset=t->t, sl=t->length;
		int line;                                         //кţItem id;
		line = tran +1;

		//vector<int> itc;
		//t->item = line;
		int quantity = 0;
		for(int i=0; i<sl; i++)
		{			
			quantity = rand()%4+1;
			//quantity = testCount[tran][i];
			t->weight = ItemProfit[iset[i]];                              //ʼĿIȨֵ
			KeyElement e(line,0);
			it_ks=(key_set.insert(e)).first;
			//it_ks->support += t->weight;
			it_ks->support += t->weight * quantity;
			it_ks->item.push_back(iset[i]);
			it_ks->count.push_back(quantity);

			//it_ks->itemnum = iset[i];
			//it_ks->num = &ItemNum[it_ks->key][0];
			//ItemNum[it_ks->key][it_ks->itemnum] += 1;
			//itc.push_back(quantity);
			//ItemNum[it_ks->key][it_ks->itemnum] = quantity;
		}

		totalTU += it_ks->support;
		for(int i=0; i<sl; i++)
		{
			ItemSupport is(iset[i]);
			it_is = is_set.find(is);
			if(it_is == is_set.end())
			{
				it_is=(is_set.insert(is)).first;
			}
			it_is->support += it_ks->support;
			it_is->tid.push_back(line);
			//if(it_is->count.size() < tran)
			//{
			//	for(int i=0; i<tran; i++)
			//		it_is->count.push_back(0);
			//}
			//it_is->count.push_back(itc[i]);
		}
		++tran;
	}
	ntrans=tran;
	setThrehold(totalTU);
	//vector<int> keyutil;

	//ͬһĿֵĴ
	//for(it_ks=key_set.begin(); it_ks!=key_set.end(); ++it_ks)
	//{
	//	for(int i=0; i<it_ks->item.size(); i++)
	//	{
	//		ItemSupport is(it_ks->item[i]);
	//		it_is = find(is_set.begin(), is_set.end(), is);			
	//		it_is->count.push_back(it_ks->count[i]);
	//	}
	//	for(it_is=is_set.begin(); it_is!=is_set.end(); ++it_is)
	//	{
	//		if(it_is->count.size() < it_ks->key)
	//		{
	//			it_is->count.push_back(0);
	//		}
	//	}
	//}


	//printout(ntrans, key_set, it_ks, ItemNum);

	//ȥȨЧõСЧֵmin_utilĿ¼Ŀitem
	if(verbose) cout << "min util:" << minutil << endl;
	vector<int> DeleteItem;
	vector<int>::iterator it_de;
	for(it_is=is_set.begin(); it_is!=is_set.end(); )
	{
		if(it_is->support < minutil)
		{
			DeleteItem.push_back(it_is->item);
			it_is = is_set.erase(it_is);
		}
		else ++it_is;
	}
	
	//for(it_list=item_list.begin(); it_list!=item_list.end(); it_list++)
	//	cout << "item:" << it_list->item << "\tutil:" << it_list->util << endl;


	//KeyElementɾЧõmin utilĿعݿ
	for(it_ks=key_set.begin(); it_ks!=key_set.end(); ++it_ks)
	{
		//for(int j=0; j<DeleteItem.size(); j++)
		//{
		it_ks->it_item = it_ks->item.begin();
		it_ks->it_count = it_ks->count.begin();
		for(int i=0; i<it_ks->item.size(); i++)
		{
			ItemSupport is(it_ks->item[i]);
			it_is = is_set.find(is);
			if(it_is != is_set.end())
				it_is->count.push_back(it_ks->count[i]);

			it_de = find(DeleteItem.begin(), DeleteItem.end(), it_ks->item[i]);
			if(it_de != DeleteItem.end())				
			//if(it_ks->item[i] == DeleteItem[j])
			{
				it_ks->support = it_ks->support - ItemProfit[it_ks->item[i]];
				it_ks->it_item = it_ks->item.erase(it_ks->it_item);
				it_ks->it_count = it_ks->count.erase(it_ks->it_count);
			}
			else
			{
				++(it_ks->it_item);
				++(it_ks->it_count);
			}
		}
		//}
		//for(int i=0; i<it_ks->item.size(); i++)
		//{
		//	ItemSupport is(it_ks->item[i]);
		//	it_is = is_set.find(is);
		//	//it_is = find(is_set.begin(), is_set.end(), is);
		//	if(it_is != is_set.end())
		//	it_is->count.push_back(it_ks->count[i]);
		//}
		for(it_is=is_set.begin(); it_is!=is_set.end(); ++it_is)
		{
			if(it_is->count.size() < it_ks->key)
			{
				it_is->count.push_back(0);
			}
		}
	}

	keyutil.resize(0);
	for(it_ks=key_set.begin(); it_ks!=key_set.end(); ++it_ks)
	{
		keyutil.push_back( it_ks->support );
	}

	item_list.clear();

	for(it_is=is_set.begin(); it_is!=is_set.end(); ++it_is)
	{
		it_list = item_list.begin();
		ItemUtil iu(it_is->item);
		//iu.item = it_is->item;
		iu.util = it_is->support;
		iu.tid = it_is->tid;
		iu.count = it_is->count;
		item_list.push_back(iu);
		//it_list->util = it_is->support;
	}
	//
	if(verbose) cout << "sort by util..." << endl;
	item_list.sort();
	itemnum = item_list.size();
	//int itran = 0;                                        //³ʼֱ
	//bool ver = true;
	//key_set.clear();
	////for(int i=0; i<L; i++)
	////{
	////	for(int j=0; j<C; j++)
	////		ItemNum[i][j] = 0;
	////}
	//while(Transaction *t = data->getNext())
	//{
	//	int *iset=t->t, sl=t->length;
	//	int line;                                         //кţItem;
	//	line = itran +1;

	//	for(int i=0; i<sl; i++)
	//	{
	//		t->weight = ItemProfit[iset[i]];                              //ʼĿIȨֵ
	//		KeyElement e(line,0);
	//		//KeyElement e(iset[i],0,0);
	//		//it_ks=key_set.find(e);
	//		for(int j=0; j<DeleteItem.size(); j++)
	//		{
	//			if(iset[i] != DeleteItem[j])
	//			{
	//				ver = false;
	//				break;
	//			}
	//			else ver = true;
	//		}
	//		if(ver)
	//		{
	//			//if(it_ks == key_set.end()) 
	//			//{
	//			it_ks=(key_set.insert(e)).first;

	//			//}
	//			it_ks->support += t->weight;
	//			it_ks->item.push_back(iset[i]);
	//			//it_ks->num = &ItemNum[it_ks->key][0];
	//			//ItemNum[it_ks->key][it_ks->item] += 1;
	//		}
	//	}
	//	++itran;
	//	//}
	//	
	//}
	//ntrans=itran;
	//printout(ntrans, key_set, it_ks, ItemNum);

	if(verbose) cout << "Bitmap after sort..." << endl;

	vector<int> key;
	key.resize(0);

	for(it_ks=key_set.begin(); it_ks!=key_set.end(); ++it_ks)
	{
		key.push_back( it_ks->key );
	}

	bitmap.resize(0);
	remap.resize(0);
	for(it_list=item_list.begin(); it_list!=item_list.end(); ++it_list)
	{
		remap.push_back( it_list->item );
	}
	bitmap.resize( remap.size() );
	for(int i=0; i<remap.size(); i++) 
		bitmap[i].setBitSize(key_set.size());

	//if(verbose) cout<<"	set bitmap g(i)"<<endl;
	int ibit=0;
	for(it_list=item_list.begin(); it_list!=item_list.end(); ++it_list)
	{
		for(int j=0; j<it_list->tid.size(); j++)
			bitmap[ibit].setBit(it_list->tid[j]-1);
		ibit++;
	}

	//tran=0;
	//bool ver = true;
	//while(Transaction *t = data->getNext())
	//{
	//	int *iset=t->t, sl=t->length;
	//	int line;                                       
	//	line = tran +1;
	//	//for(int i=0; i<DeleteItem.size(); i++)
	//	//{
	//	//	if(line == DeleteItem[i])
	//	//	{
	//	//		ver = false;
	//	//		break;
	//	//	}
	//	//	else ver = true;
	//	//}
	//	//if(ver)
	//	//{
	//	for(int i=0; i<sl; i++)
	//	{
	//		for(int j=0; j<DeleteItem.size(); j++)
	//		{
	//			if(iset[i] == DeleteItem[j])
	//			{
	//				ver = false;
	//				break;
	//			}
	//			else ver = true;
	//		}
	//		if(ver)
	//		{
	//			//int j;
	//			//for(j=key.size()-1; j>=0 && key[j]!=iset[i]; j--) ;
	//			//if(j<0) continue;
	//			//bitmap[tran].setBit(j);
	//			//for(int i=0; i<sl; i++)
	//			//{
	//				int j;
	//				for(j=remap.size()-1; j>=0 && remap[j]!=iset[i]; j--) ;
	//				if(j<0) continue;
	//				bitmap[j].setBit(tran);
	//			//}
	//		}
	//	}
	//		++tran;
	//	//}
	//}
	//printout(ItemProfit.size(), key_set, it_ks, ItemNum);

	//bitmap
	//vector<ItemBitmap> ibm;
	//ibm.resize(0);
	//ibm.resize(bitmap.size());
	for(int i=0; i<bitmap.size(); i++)
	{	
		bitmap[i].getKeyUtil(keyutil);
		bitmap[i].countSupport();
		//ibm[i] = bitmap[i];
	}

	//for(int i=0; i<bitmap.size(); i++)
	//{
	//	//bitmap[i] = ibm[remap[i]-1];
	//	printItemBitmap(bitmap[i]);
	//}

	return 0;
}


int level;
//int DCI_Close::dci_close_recursive(vector<int> closed_set, vector<int> pre_set, vector<int> post_set)
int DCI_Close::getMTWU(vector<int> closed_set, vector<int> post_set)

{
	int i,j;

	//if(verbose) 
	//{
	//	int i;
	//	cout<<level<<" [";
	//	for(i=0; i<closed_set.size(); i++) cout<<closed_set[i]<<" ";
	//	cout<<"],";
	//	//cout<<"[";
	//	//for(i=0; i<pre_set.size(); i++) cout<<pre_set[i];
	//	//cout<<"],";
	//	cout<<"[";
	//	for(i=0; i<post_set.size(); i++) cout<<post_set[i]<<" ";
	//	cout<<"]";
	//	cout<<endl;
	//}

	//bool flag = true;
	//if(closed_set.size() != 0)
	//{
	//	ItemBitmap tib(ntrans);
	//	tib=bitmap[closed_set[0]];

	//	for( j=1; j<closed_set.size(); j++) 
	//		tib.intersect( bitmap[closed_set[j]] );
	//	tib.getKeyUtil(keyutil);
	//	tib.countSupport();
	//	if( tib.getSupport() < minutil )
	//		flag = false;

	//}

	while(post_set.size())
	{
		//i = closed_set.back();
		//closed_set.pop_back();
		//post_set.push_back(i);

		//vector<int>::iterator it;
		i = post_set.front();
		//it = find(closed_set.begin(), closed_set.end(), i);
		//closed_set.erase(it);
		post_set.erase( post_set.begin() );
		
		//printvec(post_set);cout<<endl;
		vector<int> new_gen(closed_set);
		ItemBitmap tib(ntrans);
		tib=bitmap[new_gen[0]];

		new_gen.push_back(i); 

		for( j=1; j<new_gen.size(); j++) 
			tib.intersect( bitmap[new_gen[j]] );

		bool isSubset = false;
		for(it_mtwu=mtwu.begin(); it_mtwu!=mtwu.end(); it_mtwu++)
		{
			if(tib.isSubsetof(it_mtwu->tib))
			{
				if(new_gen.size() < it_mtwu->itemset.size())
				{
					isSubset = true;
				}
				break;				
			}
		}
		if(!isSubset)
		{
			//resultnum++;
			//жǱڸЧü
			tib.getKeyUtil(keyutil);
			tib.countSupport();
			if( tib.getSupport() < minutil )			//continueصwhilepostΪ0ʱһ
			{
				continue;
			}
			
			//if(mtwu.size() == 0)
			//{
			//	MTWU imtwu;
			//	imtwu.itemset = new_gen;
			//	imtwu.tib = tib;
			//	mtwu.push_back(imtwu);
			//}
			//else
			//{
			bool flag = true;
			for(it_mtwu=mtwu.begin(); it_mtwu!=mtwu.end(); )
			{
				if(it_mtwu->tib.isSubsetof(tib) && it_mtwu->itemset.size() < new_gen.size())
				{
					it_mtwu = mtwu.erase(it_mtwu);
				}
				else if(tib.isSubsetof(it_mtwu->tib) && it_mtwu->itemset.size() > new_gen.size())
				{
					flag = false;
					it_mtwu++;
				}
				else
					it_mtwu++;
			}
			if(flag)
			{
				MTWU imtwu;
				imtwu.itemset = new_gen;
				imtwu.tib = tib;
				mtwu.push_back(imtwu);

				if(new_gen.size() == maxlength)
					passRest = true;
			}
			//}
			//total ++;
		}
		htwui ++;

		if(passRest)
			break;
		vector<int> new_closed(new_gen);
		vector<int> new_post(0);

		for( j=0; j<post_set.size(); j++)
		{
			//if( tib.isSubsetof( bitmap[post_set[j]] ) ) 
			//	new_closed.push_back(post_set[j]);
			//else
				new_post.push_back(post_set[j]);
		}

		//ʵЧãõЧü
		//tib.countActualSupport(ItemProfit, new_closed, remap, ItemNum);
		//if( tib.getSupport() >= minutil )
		//{
		//	if( setsout.is_open() )
		//	{
		//		for(int j=0; j<new_closed.size(); j++) setsout<< remap[new_closed[j]] <<" ";
		//		setsout<<"("<< tib.getSupport() <<")"<<endl;
		//		resultnum++;
		//	}
		//}

		//level++;
		getMTWU(new_closed, new_post);

		//pre_set.push_back(i);
	}
	//level--;
	return 0;
}


int DCI_Close::generateCloseSets()
{
	if(verbose) cout<<"Start mining..."<<endl;
	clock_t start;
	start = clock();

	this->initBitmap();

	vector<int> closed(0),post(0);
	maxlength = bitmap.size();

	for(int i=0; i<bitmap.size(); i++) 
		post.push_back(i);
	//for(int i=bitmap.size()-1; i>=0; i--)
		//post.push_back(i);
	//post.push_back(closed.back());
	//closed.resize(post.size());

	//if(verbose) cout<<"DCI_Closed... level [closed_set],[pre_set],[post_set]"<<endl;
	cout << "\t[" << (clock()-start)/double(CLOCKS_PER_SEC) << "s]" << endl;
	level=0;
	//for(int i=level; i>0; i--)
	//	combine(post, level, i, closed, i);

	for(int i=0; i<bitmap.size(); i++)
	{
		if(passRest)
			break;
		int item;
		item = post.front();
		post.erase( post.begin() );
		closed.push_back(item);
		ItemBitmap tib(ntrans);
		tib=bitmap[closed[0]];
		bool isSubset = false;
		for(it_mtwu=mtwu.begin(); it_mtwu!=mtwu.end(); it_mtwu++)
		{
			if(tib.isSubsetof(it_mtwu->tib))
			{
				if(closed.size() < it_mtwu->itemset.size())
				{
					isSubset = true;
				}
				break;				
			}
		}
		if(!isSubset)
		{
			MTWU imtwu;
			imtwu.itemset = closed;
			imtwu.tib = tib;
			mtwu.push_back(imtwu);
		}
		maxlength = maxlength - i;
		this->getMTWU(closed, post);		
		closed.resize(0);
	}
	//this->dci_close_recursive(closed, pre, post);
	//
	cout<<"MTWU finish..."<<endl;
	cout << "\t[" << (clock()-start)/double(CLOCKS_PER_SEC) << "s]" << endl;
	generation();
	total = mtwu.size();
	resultnum = hui.size();

	return 0;
}

int DCI_Close::generation()
{
	
	for(it_mtwu=mtwu.begin(); it_mtwu!=mtwu.end(); it_mtwu++)
	{
		vector<int> closed(0),post(0);
		//it_mtwu->tib.countActualSupport(ItemProfit, it_mtwu->itemset, remap, count);
		//it_mtwu->tib.xnor(bitmap[0]);
		for(int i=0; i<it_mtwu->itemset.size(); i++)
		{
			int item = it_mtwu->itemset[i];
			post.push_back(item);
			//ItemUtil iu(remap[item]);
			//it_list = find(item_list.begin(), item_list.end(), iu);
			//itemcount.push_back(it_list->count);
		}
		this->getActualHui(closed, post);
		itemcount.resize(0);
	}

	for(it_hui=hui.begin(); it_hui!=hui.end(); it_hui++)
	{
		if( setsout.is_open() )
		{
			for(int i=0; i<it_hui->itemset.size(); i++)
				setsout<< remap[it_hui->itemset[i]] <<" ";
			setsout<<"("<< it_hui->util<<")"<<endl;
		}
	}
	
	return 1;
}

int DCI_Close::getActualHui(vector<int> closed_set, vector<int> post_set)
{
	int i;
	while(post_set.size())
	{
		i = post_set.front();
		post_set.erase( post_set.begin() );
		
		vector<int> new_gen(closed_set);
		new_gen.push_back(i);

		bool isExist = false;
		for(it_hui=hui.begin(); it_hui!=hui.end(); it_hui++)
		{
			if(this->isHuiExist(new_gen, it_hui->itemset))
			{
				isExist = true;
				break;
			}
		}

		if(!isExist)
		{

			ItemBitmap tib(ntrans);
			tib=bitmap[new_gen[0]];

			for(int j=1; j<new_gen.size(); j++) 
				tib.intersect( bitmap[new_gen[j]] );

			itemcount.clear();
			for(int i=0; i<new_gen.size(); i++)
			{
				int item = new_gen[i];
				ItemUtil iu(remap[item]);
				it_list = find(item_list.begin(), item_list.end(), iu);
				itemcount.push_back(it_list->count);
			}

			tib.countActualSupport(ItemProfit, new_gen, remap, itemcount);
			if( tib.getSupport() >= minutil )			
			{
				HUI ihui;
				ihui.itemset = new_gen;
				ihui.util = tib.getSupport();
				hui.push_back(ihui);
			}
		}

		vector<int> new_closed(new_gen);
		vector<int> new_post(0);

		for(int j=0; j<post_set.size(); j++)
		{
			new_post.push_back(post_set[j]);
		}

		level++;
		getActualHui(new_closed, new_post);

	}
	level--;
	return 0;
}

bool DCI_Close::isHuiExist(vector<int> a, vector<int> b)
{
	if(a.size() != b.size())
		return false;
	for (int i=0; i<b.size(); i++)
	{
		if (find(a.begin(), a.end(), b[i]) == a.end())
			return false;
	}
	return true;
}



